<?php

namespace Rtb_objects;

use Helper\utils;
use Helper\validate;

/**
 * Traffic class
 *
 * This class saves all the objects set by the user before sending the request.
 *
 */
class Traffic {
    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function save_rtb_objects($request, $time_stamp, $for_exchange, $campaign_id) 
	{
        $aConf = $GLOBALS['_MAX']['CONF'];
        if ($request AND $time_stamp AND $for_exchange AND $campaign_id) { 
            $Impression_object = new Impression_object();
            $imp_pk_id = $Impression_object->save($request, $time_stamp);
            $imp_object = $Impression_object->fetch($request);
			$request['is_for'] =2;
            if ($request['is_for'] == '1') {
                //Save site object
                $Site_object = new Site_object();
                $site_object_id = $Site_object->save($request, $time_stamp);
                //print_r($site_object_id); exit("site_object_id");
                $site_object = $Site_object->fetch($request);
                //Save publisher object
                $Publisher_object = new Publisher_object();
                $publisher_object_id = $Publisher_object->save($site_object_id, $flag = '1', $request, $time_stamp);
                $publisher_object = $Publisher_object->fetch($request);
                //Save content object
                $Content_object = new Content_object();
                $content_object_id = $Content_object->save($site_object_id, $flag = '1', $request, $time_stamp);
                $content_object = $Content_object->fetch($request);
                //Save producer object
                $Producer_object = new Producer_object();
                $producer_object_id = $Producer_object->save($content_object_id, $request, $time_stamp);
                $producer_object = $Producer_object->fetch($request);    
            }
            //If it is for mobile
            if ($request['is_for'] == '2') {
                //Save app object
                $App_object = new App_object(); //die("akk");
                $app_object_id = $App_object->save($request, $time_stamp);
                $app_object = $App_object->fetch($request);
				$insert_array_objects['app_object'] = $app_object;
               
                //Save publisher object
                $Publisher_object = new Publisher_object();
                $publisher_object_id = $Publisher_object->save($app_object_id, $flag = '2', $request, $time_stamp);
                $publisher_object = $Publisher_object->fetch($request);

                //Save content object
                $Content_object = new Content_object();
                $content_object_id = $Content_object->save($app_object_id, $flag = '2', $request, $time_stamp);
                $content_object = $Content_object->fetch($request);

                //Save producer object
                $Producer_object = new Producer_object();
                $producer_object_id = $Producer_object->save($content_object_id, $request, $time_stamp);
                $producer_object = $Producer_object->fetch($request);   
            }

            //Save user object
            $User_object = new User_object();
            $user_object_id = $User_object->save($request, $time_stamp);
            $user_object = $User_object->fetch($request);


            //Save device object
            $Device_object = new Device_object();
            $device_object_id = $Device_object->save($request, $time_stamp);
            $device_object = $Device_object->fetch($request);

            //Save geo object
            $Geo_object = new Geo_object();
            $geo_object_id = $Geo_object->save($user_object_id, $flag = '1', $request, $time_stamp);
            $geo_object_id = $Geo_object->save($device_object_id, $flag = '2', $request, $time_stamp);
            $geo_object = $Geo_object->fetch($request);



            //Save data object
            $Data_object = new Data_object();
            $data_object_id = $Data_object->save($user_object_id, $request, $time_stamp);
            $data_object = $Data_object->fetch($request);

 //Save format object

            $Format_object = new Format_object(); 

            $format_object_id =$Format_object->save($request, $time_stamp);

            $format_object = $Format_object->fetch($request);


            //Save segment object
            $Segment_object = new Segment_object();
            $segment_object_id = $Segment_object->save($data_object_id, $request, $time_stamp);
            $segment_object = $Segment_object->fetch($request);
			
				
            if ($request['is_for'] == '1') {
                $insert_array_objects = array('imp_object' => "$imp_object", 'site_object' => "$site_object", 'content_object' => "$content_object", 'device_object' => "$device_object", 'user_object' => "$user_object", 'publisher_object' => "$publisher_object", 'producer_object' => "$producer_object", 'geo_object' => "$geo_object", 'data_object' => "$data_object", 'segment_object' => "$segment_object");
            } else if ($request['is_for'] == '2') {
                $insert_array_objects = array('imp_object' => "$imp_object", 'app_object' => "$app_object", 'content_object' => "$content_object", 'device_object' => "$device_object", 'user_object' => "$user_object", 'publisher_object' => "$publisher_object", 'producer_object' => "$producer_object", 'geo_object' => "$geo_object", 'data_object' => "$data_object", 'segment_object' => "$segment_object");
            }
					// video
			if (isset($request['linearity'])) 
			{ 
			//Save video object
            $Video_object = new Video_object();
            $video_object_id = $Video_object->save($imp_pk_id, $request, $time_stamp);
            $video_object = $Video_object->fetch($request);	           
			$insert_array_objects['video_object'] = $video_object;			
			}
			if(isset($request['banner_width']) && !empty($request['banner_width'])) 
			{
			    //Save banner object
			    $Banner_object = new Banner_object();
			    $banner_object_id = $Banner_object->save($imp_pk_id, $request, $time_stamp);
			    $banner_object = $Banner_object->fetch($request);
			    $insert_array_objects['banner_object'] = $banner_object;

				if(!empty($format_object))
				{
				$format_objects=array('w'=>$request['format_width'],'h'=>$request['format_height']);
				$djformatobject=array('format'=>$format_objects);
				$finalbannerobj=array_merge($banner_object['banner'],$djformatobject);
				$banner=array('banner'=>$finalbannerobj);  
				}
				else
				{
				$banner=array('banner'=>$banner_object['banner']);  
				} 
           			 $insert_array_objects['banner_object'] =  json_encode($banner);
			
			}
			if(isset($request['aud_mimes']) && !empty($request['aud_mimes'])) 
			{
            //Save banner object
            $Audio_object = new Audio_object();
            $audio_object_id = $Audio_object->save($imp_pk_id, $request, $time_stamp);
            $audio_object = $Audio_object->fetch($request);
            $insert_array_objects['audio_object'] = $audio_object;
			}
            
            
            /*Native Object*/

            if (isset($request['assets']) && !empty($request['assets'])) 
			{
				
			//Save video object
            $Native_object = new Native_object();
            $native_object_id = $Native_object->save($imp_pk_id, $request, $time_stamp); 
            $native_object = $Native_object->fetch($request);	           
			$insert_array_objects['native_object'] = $native_object;	

		      //print_r($native_object); exit("native_object");
			}
           
            if (isset($request['deal_bid']) && !empty($request['deal_bid'])) 
			{
			$request['pmp'] = (int) 1;	
			//Save Pmp object
            $Pmp_object = new Pmp_object();
            $pmp_object_id = $Pmp_object->save($imp_pk_id, $request, $time_stamp);
            $pmp_object = $Pmp_object->fetch($request);	
            
            //Save Deal object
            $Deal_object = new Deal_object();
            $deal_object_id = $Deal_object->save($imp_pk_id, $pmp_object_id, $request, $time_stamp);
            $deal_object = $Deal_object->fetch($request);
            
			$insert_array_objects['pmp_object'] = $pmp_object;
			$insert_array_objects['deal_object'] = $deal_object;	
			
			}
						
            $insert_array = array();

            if($request AND $time_stamp AND $insert_array_objects) {
                $object = $this->request_object();
                #Get original name and alias name
                $request_object = $this->format_request_object($object);
                #Replace with original params
                $utils = new Utils;
                $defined_constants = $utils->defined_constants();


                foreach ($request_object as $key => $data)
                {
                    $prepared_request[$defined_constants[$key]['name']] = $data;
				}

                if (isset($request_object)) {
                    foreach ($request_object as $key => $data) {
                        if (array_key_exists($key, $request)) {
							
                            if (is_array($request[$key])) {
                                $formated = implode(",", array_values($request[$key]));
                                $json_converted = ($formated);
                            } else {
								if($key=='auction_type')
								{
								$json_converted = (int)($request[$key]);	
								}
								else
								{
                                $json_converted = ($request[$key]);
								}
                            }
							
                            $insert_array[$data] = $json_converted;
                        }
                    }
                } 
                //Merge custom request objects before inserting
                $insert_array_objects = array_merge($insert_array, $insert_array_objects);
				$rand = substr(uniqid('', true), -32);
				$bidreqid=base64_encode($rand);
				$insert_array_objects['bidreqid']=$rand;
                //Create a database connection
				$objects = $insert_array_objects;
					foreach($objects as &$object)
					{
							if($this->isJSON($object))
							{
								$object = json_decode($object,true);
							}
					}
				$final_data = array();	
				$final_data['exchange_id'] =  $for_exchange;
				$final_data['campaign_id'] =  $campaign_id;
				if(isset($objects['device_object']['device']))
				{
					$final_data['device'] = $objects['device_object']['device'];
				}	
				if(isset($objects['app_object']['app']))
				{
					$final_data['app'] = $objects['app_object']['app'];
				}
				if(isset($objects['site_object']['site']))
				{
					$final_data['site'] = $objects['site_object']['site'];
				}	
				if(isset($objects['geo_object']['geo']))
				{
					$final_data['geo'] = $objects['geo_object']['geo'];
				}	
				$final_data['request_details'] = $objects;
				$mongoConnection = $GLOBALS['_MAX']['CONF']['mongoConnection'];
				$bidreqid = $mongoConnection->demand_request_insert($final_data);
				$djaxresponse=array('requestid'=>$bidreqid,'djaxresponse'=>$insert_array_objects);
                return $djaxresponse;
            }
        }
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function encrypt($r) {
        return ('"' . base64_encode($r) . '"');
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function request_object() {
        //Request Object
        $request_object = array(
            'auction_type' => array('name' => 'at', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Request_Object'),
            'request_max_time' => array('name' => 'tmax', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Request_Object'),
            'buyer_seats' => array('name' => 'wseat', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Request_Object'),
            'allimps' => array('name' => 'allimps', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Request_Object'),
            'currency' => array('name' => 'cur', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Request_Object'),
            'blocked_advertiser_category' => array('name' => 'bcat', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Request_Object'),
            'blocked_advertiser' => array('name' => 'badv', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Request_Object'),
            'test' => array('name' => 'test', 'type' => '_integer', 'scope' => 'optional', 'object' => 'Request_Object'),
            'bapp' => array('name' => 'bapp', 'type' => '_array_of_string', 'scope' => 'optional', 'object' => 'Request_Object'),   
        );
        return $request_object;
    }

    /*
     * 
     * name: unknown
     * @param
     * @return
     * 
     */

    public function format_request_object($object) {
        if ($object) {
            $request_object = array();
            foreach ($object as $key => $data)
                $request_object[$key] = $data['name'];
            return $request_object;
        }
    }
    
    public function isJSON($string)
    {
		return is_string($string) && is_array(json_decode($string, true)) && (json_last_error() == JSON_ERROR_NONE) ? true : false;
	}

}

/* End of file Traffic.php */
